//=============================================================================
// Terrorist.
//=============================================================================
class BLTestPawn extends HumanMilitary;

var int MaxHealthMark;

var BLHealthSprite HealthSprite;

function BeefHealth(int i)
{
 MaxHealthMark = i;
 Health = i;
 
 //BroadcastMessage("Health Buffed To "$Health$"!");
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	local int   actualDamage;
	local float headOffsetZ, headOffsetY, armOffset;

	/*if (InstigatedBy.IsA('DeusExPlayer'))
	{
	 if (DeusExPlayer(InstigatedBy).InHand.IsA('WeaponCrowbar'))
	 {
	  BeefHealth();
	 }
	 
	 //InformMutator();
	}*/

	actualDamage = Damage;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	// if the pawn is stunned, damage is 4X
	if (bStunned)
		actualDamage *= 4;

	// if the pawn is hit from behind at point-blank range, he is killed instantly
	else if (offset.x < 0)
		if ((instigatedBy != None) && (VSize(instigatedBy.Location - Location) < 64))
			actualDamage  *= 10;

	actualDamage = Level.Game.ReduceDamage(actualDamage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);

	// gas, EMP and nanovirus do no damage
	if (damageType == 'TearGas' || damageType == 'EMP' || damageType == 'NanoVirus')
		actualDamage = 0;

	if (damageType == 'Acid') actualDamage *= (Default.Health / 50);

	return actualDamage;

}

function GenerateTotalHealth()
{
}

function EHitLocation HandleDamage(int actualDamage, Vector hitLocation, Vector offset, name damageType)
{
	local EHitLocation hitPos;
	local float        headOffsetZ, headOffsetY, armOffset;

	local int TotalDamage;
	local bool bCrit, bReduced;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	hitPos = HITLOC_None;

	if (actualDamage > 0)
	{
		if (offset.z > headOffsetZ)		// head
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
			{
				// don't allow headshots with stunning weapons
				if ((damageType == 'Stunned') || (damageType == 'KnockedOut'))
					TotalDamage = 0;
				else
				{
					bCrit = True;
					TotalDamage = ActualDamage * 2;
				}
				if (offset.x < 0.0)
					hitPos = HITLOC_HeadBack;
				else
					hitPos = HITLOC_HeadFront;
			}
			else  // sides of head treated as torso
			{
				TotalDamage = ActualDamage;
				
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
			}
		}
		else						// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	if (TotalDamage > 0) SpawnDamageNumbers(TotalDamage, bCrit, bReduced);

	Health -= TotalDamage;

	GenerateTotalHealth();


	//InformMutator();
	
	UpdateHealthSprite();
	
	return hitPos;
}

function SpawnDamageNumbers(int Dam, bool bCrit, bool bReduced)
{
 local String S, CurS, Color;
 local int i, j, k, l;
 
 S = String(Dam);
 
 CurS = S;
 
 i = int(Left(CurS, Len(CurS) - 1));
 CurS = Right(CurS, 1);

 j = int(Left(CurS, Len(CurS) - 1));
 CurS = Right(CurS, 1);
 
 k = int(Left(CurS, Len(CurS) - 1));
 CurS = Right(CurS, 1);

 l = int(Left(CurS, Len(CurS) - 1));
 
 if (bCrit) Color = "Red";
 if (bReduced && !bCrit) Color = "Gray";
 if (!bReduced && !bCrit) Color = "White";
 
 SpawnNumbers(i, j, k, l, Color, Len(S));
}

function DeusExPlayer FirstPlayer()
{
 local DeusExPlayer Play;
 
 forEach allActors(class'DeusExPlayer', Play)
 {
  return Play;
 }
}

function SpawnNumbers(int i, int j, int k, int l, string Color, int Length)
{
 local BLNumberSprite N;
 local Vector V, O;
 
 //BroadcastMessage(Length);
 
 if (i == 0) return;
 
 V = (vect(0,0,1) * CollisionHeight * 1.2) + ((vect(0,1,0) >> FirstPlayer().Rotation) * Rand(10)) + (vect(0,0,1) * Rand(10));
 
 O = vect(0,4,0) >> FirstPlayer().Rotation;
 
 N = Spawn(class'BLNumberSprite', Self,,Location + V + O);
 N.Color = Color;
 N.Number = i;
 N.UpdateTexture();
 
 if (Length > 1)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 2));
  N.Color = Color;
  N.Number = j;
  N.UpdateTexture();
 }
 
 if (Length > 2)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 3));
  N.Color = Color;
  N.Number = k;
  N.UpdateTexture();
 }
 
 if (Length > 3)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 4));
  N.Color = Color;
  N.Number = l;
  N.UpdateTexture();
 }
}

function UpdateHealthSprite()
{
 if (HealthSprite == None) SpawnHealthSprite();
 
 HealthSprite.UpdateTexture(Health, MaxHealthMark);
}

function SpawnHealthSprite()
{
 HealthSprite = Spawn(class'BLHealthSprite', Self);
 HealthSprite.SetTimer(0.02, True);
}

function TakeDamage(int D, Pawn Inst, vector H, vector M, name T)
{
 Super.TakeDamage(D, Inst, H, M, T);
}

defaultproperties
{
     MinHealth=40.000000
     CarcassType=Class'DeusEx.TerroristCarcass'
     WalkingSpeed=0.296000
     AvoidAccuracy=0.100000
     CrouchRate=0.250000
     SprintRate=0.250000
     walkAnimMult=0.780000
     GroundSpeed=200.000000
     Health=100
     HealthHead=100
     HealthTorso=100
     HealthLegLeft=100
     HealthLegRight=100
     HealthArmLeft=100
     HealthArmRight=100
     MaxHealthMark=100
     Texture=Texture'DeusExItems.Skins.PinkMaskTex'
     Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.TerroristTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.TerroristTex1'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.GogglesTex1'
     MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="Terrorist"
     FamiliarName="Terrorist"
     UnfamiliarName="Terrorist"
}
